/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.parser;

import com.ibm.hwmca.fw.servlet.pmod.impl.parser.ModelParserSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class ModelParserSourceImpl
implements ModelParserSource {
    public static final String TRACE_MASK = "XPMPMPS";
    private char[] data;
    private int sourceStartOffset = 0;
    private int numBytes;
    private int mark;
    private InputStream stream;

    public ModelParserSourceImpl(InputStream is, int sourceStartOffset) throws IOException {
        this(is);
        this.setSourceStartOffset(sourceStartOffset);
    }

    public ModelParserSourceImpl(InputStream is) throws IOException {
        this.stream = is;
        this.numBytes = is.available();
        this.data = new char[this.numBytes];
        InputStreamReader reader = new InputStreamReader(is);
        ((Reader)reader).read(this.data, 0, this.numBytes);
        try {
            ((Reader)reader).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setSourceStartOffset(int sourceStartOffset) {
        this.sourceStartOffset = sourceStartOffset;
    }

    public int mark() {
        return this.mark;
    }

    public void toMark(int mark) {
        this.mark = mark;
    }

    public char getChar() {
        return this.data[this.mark++];
    }

    public char peekChar() {
        return this.data[this.mark];
    }

    public void skipWhitespace() {
        while (this.mark < this.numBytes && (this.data[this.mark] == ' ' || this.data[this.mark] == '\n' || this.data[this.mark] == '\r' || this.data[this.mark] == '\t' || this.data[this.mark] == '\f')) {
            ++this.mark;
        }
    }

    public String currentLocation() {
        int[] locations = new int[2];
        this.currentLocation(locations);
        return "line:" + Integer.toString(locations[0]) + " column:" + Integer.toString(locations[1]);
    }

    public void currentLocation(int[] locations) {
        int lineNo = 1;
        int lineOffset = 0;
        for (int i = this.sourceStartOffset; i < this.mark; ++i) {
            if (this.data[i] == '\n') {
                ++lineNo;
                lineOffset = 0;
                continue;
            }
            ++lineOffset;
        }
        locations[0] = lineNo;
        locations[1] = lineOffset;
    }

    public boolean ifNextConsume(char[] pattern) {
        int patternLength = pattern.length;
        if (patternLength > this.mark + this.numBytes) {
            return false;
        }
        for (int i = 0; i < patternLength; ++i) {
            if (this.data[this.mark + i] == pattern[i]) continue;
            return false;
        }
        this.mark += patternLength;
        return true;
    }

    public boolean ifNextConsume(char pattern) {
        if (this.data[this.mark] == pattern) {
            ++this.mark;
            return true;
        }
        return false;
    }

    public boolean ifNext(char[] pattern) {
        int patternLength = pattern.length;
        if (patternLength > this.mark + this.numBytes) {
            return false;
        }
        for (int i = 0; i < patternLength; ++i) {
            if (this.data[this.mark + i] == pattern[i]) continue;
            return false;
        }
        return true;
    }

    public boolean ifNext(char pattern) {
        return this.data[this.mark] == pattern;
    }

    public int seekTo(char[] pattern) {
        boolean found = false;
        int patternLength = pattern.length;
        int oldMark = this.mark;
        while (this.mark < this.numBytes && !found) {
            found = true;
            for (int i = 0; i < patternLength; ++i) {
                if (this.data[this.mark + i] == pattern[i]) continue;
                found = false;
                i = patternLength;
            }
            if (found) continue;
            ++this.mark;
        }
        if (this.mark == this.numBytes) {
            this.mark = oldMark;
            return -1;
        }
        return this.mark;
    }

    public int seekTo(char pattern) {
        int oldMark = this.mark;
        while (this.mark < this.numBytes && this.data[this.mark] != pattern) {
            ++this.mark;
        }
        if (this.mark == this.numBytes) {
            this.mark = oldMark;
            return -1;
        }
        return this.mark;
    }

    public int seekToAny(char[] pattern) {
        boolean found = false;
        int patternLength = pattern.length;
        int oldMark = this.mark;
        while (this.mark < this.numBytes && !found) {
            for (int i = 0; i < patternLength; ++i) {
                if (this.data[this.mark] != pattern[i]) continue;
                found = true;
                i = patternLength;
            }
            if (found) continue;
            ++this.mark;
        }
        if (this.mark == this.numBytes) {
            this.mark = oldMark;
            return -1;
        }
        return this.mark;
    }

    public char[] getBuffer() {
        return this.data;
    }

    public void adjustCursor(int count) {
        this.mark += count;
    }

    public String nextToken() {
        this.skipWhitespace();
        int oldMark = this.mark;
        while (this.mark < this.numBytes && this.data[this.mark] != ' ' && this.data[this.mark] != '\n' && this.data[this.mark] != '\r' && this.data[this.mark] != '\t' && this.data[this.mark] != '\f') {
            ++this.mark;
        }
        return new String(this.data, oldMark, this.mark - oldMark);
    }

    public String nextToken(char[] delimiters) {
        this.skipWhitespace();
        int oldMark = this.mark;
        this.seekToAny(delimiters);
        return new String(this.data, oldMark, this.mark - oldMark);
    }
}

